/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import io.github.fabricators_of_create.porting_lib.util.LevelUtil;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.data.tags.BlockTagGenerator;

public class AntibuilderBlockEntity
extends class_2586 {
    private static final int REVERT_CHANCE = 10;
    private static final int RADIUS = 4;
    private static final int DIAMETER = 9;
    private static final double PLAYER_RANGE = 16.0;
    private final Random rand = new Random();
    private int tickCount;
    private boolean slowScan;
    private int ticksSinceChange;
    private class_2680[] blockData;

    public AntibuilderBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TFBlockEntities.ANTIBUILDER.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AntibuilderBlockEntity te) {
        if (te.anyPlayerInRange()) {
            ++te.tickCount;
            if (level.field_9236) {
                double x = (float)pos.method_10263() + level.field_9229.nextFloat();
                double y = (float)pos.method_10264() + level.field_9229.nextFloat();
                double z = (float)pos.method_10260() + level.field_9229.nextFloat();
                level.method_8406((class_2394)class_2390.field_11188, x, y, z, 0.0, 0.0, 0.0);
                if (te.rand.nextInt(10) == 0) {
                    te.makeRandomOutline();
                    te.makeRandomOutline();
                    te.makeRandomOutline();
                }
            } else {
                if (te.blockData == null && LevelUtil.isAreaLoaded((class_1936)level, (class_2338)pos, (int)4)) {
                    te.captureBlockData();
                    te.slowScan = true;
                }
                if (!(te.blockData == null || te.slowScan && te.tickCount % 20 != 0)) {
                    if (te.scanAndRevertChanges()) {
                        te.slowScan = false;
                        te.ticksSinceChange = 0;
                    } else {
                        ++te.ticksSinceChange;
                        if (te.ticksSinceChange > 20) {
                            te.slowScan = true;
                        }
                    }
                }
            }
        } else {
            te.blockData = null;
            te.tickCount = 0;
        }
    }

    private void makeRandomOutline() {
        this.makeOutline(this.rand.nextInt(12));
    }

    private void makeOutline(int outline) {
        double sx = this.field_11867.method_10263();
        double sy = this.field_11867.method_10264();
        double sz = this.field_11867.method_10260();
        double dx = this.field_11867.method_10263();
        double dy = this.field_11867.method_10264();
        double dz = this.field_11867.method_10260();
        switch (outline) {
            case 0: 
            case 8: {
                sx -= 4.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 1: 
            case 9: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 2: 
            case 10: {
                sx -= 4.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 3: 
            case 11: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 4: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 5: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 6: {
                sx += 5.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 7: {
                sx -= 4.0;
                dx -= 4.0;
                sz += 5.0;
                dz += 5.0;
            }
        }
        switch (outline) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                sy += 5.0;
                dy += 5.0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sy -= 4.0;
                dy += 5.0;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                sy -= 4.0;
                dy -= 4.0;
            }
        }
        if (this.rand.nextBoolean()) {
            this.drawParticleLine((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, dx, dy, dz);
        } else {
            this.drawParticleLine(sx, sy, sz, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
        }
        this.drawParticleLine(sx, sy, sz, dx, dy, dz);
    }

    private void drawParticleLine(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 16;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            double tx = srcX + (destX - srcX) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            this.field_11863.method_8406((class_2394)class_2390.field_11188, tx, ty, tz, 0.0, 0.0, 0.0);
        }
    }

    private boolean scanAndRevertChanges() {
        int index = 0;
        boolean reverted = false;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    class_2680 stateThere = this.field_11863.method_8320(this.field_11867.method_10069(x, y, z));
                    if (this.blockData[index].method_26204() != stateThere.method_26204()) {
                        if (this.revertBlock(this.field_11867.method_10069(x, y, z), stateThere, this.blockData[index])) {
                            reverted = true;
                        } else {
                            this.blockData[index] = stateThere;
                        }
                    }
                    ++index;
                }
            }
        }
        return reverted;
    }

    private boolean revertBlock(class_2338 pos, class_2680 stateThere, class_2680 replaceWith) {
        if (stateThere.method_26215() && !replaceWith.method_26207().method_15801()) {
            return false;
        }
        if (stateThere.method_26214((class_1922)this.field_11863, pos) < 0.0f || this.isUnrevertable(stateThere, replaceWith)) {
            return false;
        }
        if (this.rand.nextInt(10) == 0) {
            if (!replaceWith.method_26215()) {
                replaceWith = ((class_2248)TFBlocks.ANTIBUILT_BLOCK.get()).method_9564();
            }
            if (stateThere.method_26215()) {
                this.field_11863.method_20290(2001, pos, class_2248.method_9507((class_2680)replaceWith));
            }
            class_2248.method_30094((class_2680)stateThere, (class_2680)replaceWith, (class_1936)this.field_11863, (class_2338)pos, (int)2);
        }
        return true;
    }

    private boolean isUnrevertable(class_2680 stateThere, class_2680 replaceWith) {
        return stateThere.method_26164(BlockTagGenerator.ANTIBUILDER_IGNORES) || replaceWith.method_26164(BlockTagGenerator.ANTIBUILDER_IGNORES);
    }

    private void captureBlockData() {
        this.blockData = new class_2680[729];
        int index = 0;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    this.blockData[index] = this.field_11863.method_8320(this.field_11867.method_10069(x, y, z));
                    ++index;
                }
            }
        }
    }

    private boolean anyPlayerInRange() {
        return this.field_11863.method_18458((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, 16.0);
    }
}

